package ga.examples;

import ga.core.algorithm.automatic.SGA;
import ga.core.individual.IIndividualFactory;
import ga.core.individual.TemplateIndividualFactory;
import ga.core.individual.population.KMeansClusterPopulation;
import ga.core.selection.TournamentSelector;
import ga.examples.quadratic.QuadraticClusterCrossoverOp;
import ga.examples.quadratic.QuadraticClusterEvaluator;
import ga.examples.quadratic.QuadraticClusterIndividual;
import ga.examples.quadratic.QuadraticClusterMutationOp;

import java.util.logging.Logger;

public final class QuadraticFunctionClusterExample {

  // the logger for this class
  private static final Logger LOGGER = Logger
      .getLogger(QuadraticFunctionClusterExample.class.getName());

  private QuadraticFunctionClusterExample() {
  }

  public static void main(final String[] args) {
    final IIndividualFactory<QuadraticClusterIndividual> factory = new TemplateIndividualFactory<QuadraticClusterIndividual>(
        new QuadraticClusterIndividual());
    final KMeansClusterPopulation<QuadraticClusterIndividual> population = new KMeansClusterPopulation<QuadraticClusterIndividual>(
        factory, 200, 20);

    // final IPopulation<QuadraticIndividual> population = new
    // KMeansClusterPopulation<QuadraticIndividual>(
    // factory, 100, 10);

    final QuadraticClusterEvaluator evaluator = new QuadraticClusterEvaluator(
        42);
    final TournamentSelector<QuadraticClusterIndividual> selector = new TournamentSelector<QuadraticClusterIndividual>(
        3);
    final QuadraticClusterCrossoverOp crossOverOp = new QuadraticClusterCrossoverOp(
        55);
    final QuadraticClusterMutationOp mutationOp = new QuadraticClusterMutationOp(
        15);

    final SGA<QuadraticClusterIndividual> algorithm = new SGA<QuadraticClusterIndividual>(
        population, evaluator, selector, mutationOp, crossOverOp, true);

    algorithm.init();

    for (int i = 0; i <= 3000; i++) {
      LOGGER.info("Generation " + i);
      LOGGER.info(algorithm.getPopulation().toString());
      algorithm.step();

      for (final QuadraticClusterIndividual ind : algorithm.getPopulation()) {
        if (ind.getResult() == evaluator.getTarget()) {
          LOGGER.info("Done: " + ind);
          LOGGER.info("Generation " + i);
          return;
        }
      }

      final QuadraticClusterIndividual fittest = algorithm.getPopulation()
          .getFittestIndividual();
      LOGGER.info("Fittest: " + fittest);

      if (fittest.getResult() == evaluator.getTarget()) {
        LOGGER.info("Generation " + i);
        break;
      }
    }
  }
}
